/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fy extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Acre-standerttiid",
               "",
               "Acre-simmertiid",
               "",
               "Acre-tiid",
               "",
            };
        final String[] Cook = new String[] {
               "Cookeil\u00e2nse standerttiid",
               "",
               "Cookeil\u00e2nse halve simmertiid",
               "",
               "Cookeil\u00e2nse tiid",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubaanske standerttiid",
               "",
               "Kubaanske simmertiid",
               "",
               "Kubaanske tiid",
               "",
            };
        final String[] Fiji = new String[] {
               "Fijyske standerttiid",
               "",
               "Fijyske simmertiid",
               "",
               "Fijyske tiid",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf standerttiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd standerttiid",
               "",
               "Hovd simmertiid",
               "",
               "Hovd tiid",
               "",
            };
        final String[] Iran = new String[] {
               "Iraanske standerttiid",
               "",
               "Iraanske simmertiid",
               "",
               "Iraanske tiid",
               "",
            };
        final String[] Niue = new String[] {
               "Niuese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-standerttiid",
               "",
               "Omsk-simmertiid",
               "",
               "Omsk-tiid",
               "",
            };
        final String[] Peru = new String[] {
               "Peruaanske standerttiid",
               "",
               "Peruaanske simmertiid",
               "",
               "Peruaanske tiid",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Sileenske standerttiid",
               "",
               "Sileenske simmertiid",
               "",
               "Sileenske tiid",
               "",
            };
        final String[] China = new String[] {
               "Sineeske standerttiid",
               "",
               "Sineeske simmertiid",
               "",
               "Sineeske tiid",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokoseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Yndiaaske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japanske standerttiid",
               "",
               "Japanske simmertiid",
               "",
               "Japanske tiid",
               "",
            };
        final String[] Korea = new String[] {
               "Koreaanske standerttiid",
               "",
               "Koreaanske simmertiid",
               "",
               "Koreaanske tiid",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauruaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Belause tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoaanske standerttiid",
               "",
               "Samoaanske simmertiid",
               "",
               "Samoaanske tiid",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaanske standerttiid",
               "",
               "Tongaanske simmertiid",
               "",
               "Tongaanske tiid",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-standerttiid",
               "",
               "Alaska-simmertiid",
               "",
               "Alaska-tiid",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazone-standerttiid",
               "",
               "Amazone-simmertiid",
               "",
               "Amazone-tiid",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-standerttiid",
               "",
               "Anadyr-simmertiid",
               "",
               "Anadyr-tiid",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-standerttiid",
               "",
               "Azoren-simmertiid",
               "",
               "Azoren-tiid",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneise tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Peaskeeil\u00e2nske standerttiid",
               "",
               "Peaskeeil\u00e2nske simmertiid",
               "",
               "Peaskeeil\u00e2nske tiid",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Isra\u00eblyske standerttiid",
               "",
               "Isra\u00eblyske simmertiid",
               "",
               "Isra\u00eblyske tiid",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosraese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou-standerttiid",
               "",
               "Moskou-simmertiid",
               "",
               "Moskou-tiid",
               "",
            };
        final String[] Ponape = new String[] {
               "Pohnpei tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-standerttiid",
               "",
               "Samara-simmertiid",
               "",
               "Samara-tiid",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei standerttiid",
               "",
               "Taipei simmertiid",
               "",
               "Taipei tiid",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futunase tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabyske standerttiid",
               "",
               "Arabyske simmertiid",
               "",
               "Arabyske tiid",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeense standerttiid",
               "",
               "Armeense simmertiid",
               "",
               "Armeense tiid",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham standerttiid",
               "",
               "Chatham simmertiid",
               "",
               "Chatham tiid",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoraanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiereil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgyske standerttiid",
               "",
               "Georgyske simmertiid",
               "",
               "Georgyske tiid",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standerttiid",
               "",
               "Irkoetsk-simmertiid",
               "",
               "Irkoetsk-tiid",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-standerttiid",
               "",
               "Magadan-simmertiid",
               "",
               "Magadan-tiid",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeil\u00e2nske standerttiid",
               "",
               "Norfolkeil\u00e2nske simmertiid",
               "",
               "Norfolkeil\u00e2nske tiid",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standerttiid",
               "",
               "Fernando de Noronha-simmertiid",
               "",
               "Fernando de Noronha-tiid",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayaanske standerttiid",
               "",
               "Uruguayaanske simmertiid",
               "",
               "Uruguayaanske tiid",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuaanske standerttiid",
               "",
               "Vanuatuaanske simmertiid",
               "",
               "Vanuatuaanske tiid",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standerttiid",
               "",
               "Jakoetsk-simmertiid",
               "",
               "Jakoetsk-tiid",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-standerttiid",
               "",
               "Atlantic-simmertiid",
               "",
               "Atlantic-tiid",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brazyljaanske standerttiid",
               "",
               "Brazyljaanske simmertiid",
               "",
               "Brazyljaanske tiid",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolombiaanske standerttiid",
               "",
               "Kolombiaanske simmertiid",
               "",
               "Kolombiaanske tiid",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkl\u00e2neil\u00e2nske standerttiid",
               "",
               "Falkl\u00e2neil\u00e2nske simmertiid",
               "",
               "Falkl\u00e2neil\u00e2nske tiid",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maleisyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar standerttiid",
               "",
               "Ulaanbaatar simmertiid",
               "",
               "Ulaanbaatar tiid",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistaanske standerttiid",
               "",
               "Pakistaanske simmertiid",
               "",
               "Pakistaanske tiid",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayaanske standerttiid",
               "",
               "Paraguayaanske simmertiid",
               "",
               "Paraguayaanske tiid",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneill\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-standerttiid",
               "",
               "Sachalin-simmertiid",
               "",
               "Sachalin-tiid",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaamske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentynske standerttiid",
               "",
               "Argentynske simmertiid",
               "",
               "Argentynske tiid",
               "",
            };
        final String[] Christmas = new String[] {
               "Krysteil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongse standerttiid",
               "",
               "Hongkongse simmertiid",
               "",
               "Hongkongse tiid",
               "",
            };
        final String[] Indochina = new String[] {
               "Yndochinese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamtsjatski-standerttiid",
               "",
               "Petropavlovsk-Kamtsjatski-simmertiid",
               "",
               "Petropavlovsk-Kamtsjatski-tiid",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-eil\u00e2nske standerttiid",
               "",
               "Lord Howe-eil\u00e2nske simmertiid",
               "",
               "Lord Howe-eil\u00e2nske tiid",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesaseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiaanske standerttiid",
               "",
               "Mauritiaanske simmertiid",
               "",
               "Mauritiaanske tiid",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporese standerttiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Fenezolaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-standerttiid",
               "",
               "Wolgograd-simmertiid",
               "",
               "Wolgograd-tiid",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbeidzjaanske standerttiid",
               "",
               "Azerbeidzjaanske simmertiid",
               "",
               "Azerbeidzjaanske tiid",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bengalese standerttiid",
               "",
               "Bengalese simmertiid",
               "",
               "Bengalese tiid",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaapverdyske standerttiid",
               "",
               "Kaapverdyske simmertiid",
               "",
               "Kaapverdyske tiid",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "East-Timorese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjiekse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oezbeekse standerttiid",
               "",
               "Oezbeekse simmertiid",
               "",
               "Oezbeekse tiid",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standerttiid",
               "",
               "Krasnojarsk-simmertiid",
               "",
               "Krasnojarsk-tiid",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nij-Seel\u00e2nske standerttiid",
               "",
               "Nij-Seel\u00e2nske simmertiid",
               "",
               "Nij-Seel\u00e2nske tiid",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standerttiid",
               "",
               "Novosibirsk-simmertiid",
               "",
               "Novosibirsk-tiid",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipijnse standerttiid",
               "",
               "Filipijnse simmertiid",
               "",
               "Filipijnse tiid",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standerttiid",
               "",
               "Vladivostok-simmertiid",
               "",
               "Vladivostok-tiid",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Yndyske Oceaan-tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundl\u00e2nske-standerttiid",
               "",
               "Newfoundl\u00e2nske-simmertiid",
               "",
               "Newfoundl\u00e2nske-tiid",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeense standerttiid",
               "",
               "Turkmeense simmertiid",
               "",
               "Turkmeense tiid",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fr\u00e2ns-Guyaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nij-Kaledonyske standerttiid",
               "",
               "Nij-Kaledonyske simmertiid",
               "",
               "Nij-Kaledonyske tiid",
               "",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fbd-Georgyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinenburg-standerttiid",
               "",
               "Jekaterinenburg-simmertiid",
               "",
               "Jekaterinenburg-tiid",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Sintraal-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "East-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "West-Afrikaanske standerttiid",
               "",
               "West-Afrikaanske simmertiid",
               "",
               "West-Afrikaanske tiid",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Midden-Europeeske standerttiid",
               "CET",
               "Midden-Europeeske simmertiid",
               "CEST",
               "Midden-Europeeske tiid",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "East-Europeeske standerttiid",
               "EET",
               "East-Europeeske simmertiid",
               "EEST",
               "East-Europeeske tiid",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "West-Europeeske standerttiid",
               "WET",
               "West-Europeeske simmertiid",
               "WEST",
               "West-Europeeske tiid",
               "WET",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fbd-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Central-standerttiid",
               "",
               "Central-simmertiid",
               "",
               "Central-tiid",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-standerttiid",
               "",
               "Eastern-simmertiid",
               "",
               "Eastern-tiid",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Pasifik-standerttiid",
               "",
               "Pasifik-simmertiid",
               "",
               "Pasifik-tiid",
               "",
            };
        final String[] French_Southern = new String[] {
               "Fr\u00e2nske S\u00fadlike en Antarctyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoetyske standerttiid",
               "",
               "Hawaii-Aleoetyske simmertiid",
               "",
               "Hawaii-Aleoetyske tiid",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixeil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre en Miquelon-standerttiid",
               "",
               "Saint Pierre en Miquelon-simmertiid",
               "",
               "Saint Pierre en Miquelon-tiid",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-standerttiid",
               "",
               "Mountain-simmertiid",
               "",
               "Mountain-tiid",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nij-Guineeske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Midden-Australyske standerttiid",
               "",
               "Midden-Australyske simmertiid",
               "",
               "Midden-Australyske tiid",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "East-Australyske standerttiid",
               "",
               "East-Australyske simmertiid",
               "",
               "East-Australyske tiid",
               "",
            };
        final String[] Australia_Western = new String[] {
               "West-Australyske standerttiid",
               "",
               "West-Australyske simmertiid",
               "",
               "West-Australyske tiid",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "East-Groenl\u00e2nske standerttiid",
               "",
               "East-Groenl\u00e2nske simmertiid",
               "",
               "East-Groenl\u00e2nske tiid",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "West-Groenl\u00e2nske standerttiid",
               "",
               "West-Groenl\u00e2nske simmertiid",
               "",
               "West-Groenl\u00e2nske tiid",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Sintraal-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "East-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "West-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "East-Kazachse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West-Kazachse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Midden-Australyske westelijke standerttiid",
               "",
               "Midden-Australyske westelijke simmertiid",
               "",
               "Midden-Australyske westelijke tiid",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Ierse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Mountain },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Mountain },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakoe" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Beirut", "Beiroet" },
            { "timezone.excity.Asia/Kuwait", "Koeweit" },
            { "timezone.excity.Asia/Manila", "Manilla" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minhstad" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Unbekende st\u00ead" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Cairo", "Ca\u00efro" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "timezone.excity.Asia/Irkutsk", "Irkoetsk" },
            { "timezone.excity.Asia/Yakutsk", "Jakoetsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Parys" },
            { "timezone.excity.Indian/Cocos", "Cocoseilannen" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Dushanbe", "Dusjanbe" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "Sjanghai" },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "timezone.excity.Europe/Athens", "Athene" },
            { "timezone.excity.Europe/Berlin", "Berlyn" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Londen" },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "timezone.excity.Europe/Prague", "Praach" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wenen" },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Chagos", "Chagosarchipel" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Europe/Vatican", "Fatikaanst\u00ead" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Peaskeeil\u00e2n" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/Khartoum", "Khartoem" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom-Penh" },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Atlantic/Canary", "Kanaryske Eilannen" },
            { "timezone.excity.Atlantic/Faeroe", "Faer\u00f6er" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Budapest", "Boedapest" },
            { "timezone.excity.Europe/Istanbul", "Istanboel" },
            { "timezone.excity.Europe/Uzhgorod", "Oezjhorod" },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
            { "timezone.excity.Pacific/Gambier", "Gambiereilannen" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Europe/Bucharest", "Boekarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Krysteil\u00e2n" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizja" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury-eil\u00e2n" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Marquesas", "Marquesaseilannen" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinenburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sint-Helena" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Mexico-stad" },
            { "timezone.excity.America/Porto_Velho", "P\u00f4rto Velho" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaapverdi\u00eb" },
            { "timezone.excity.America/Lower_Princes", "Beneden Prinsen Kwartier" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00fbd-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Noard-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Noard-Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Noard-Dakota" },
        };
        return data;
    }
}
